<?php
   /*
    * parseinput.inc
    *
    * Written by: Jesus M. Castagnetto
    * Created on: Mon Feb 1, 1999
    */

   /* These functions are used to parse the input from variables that can
    * contain:
    * (a) a comma separated list, e.g. x,y,z
    * (b) an array of values
    * (c) a numeric range separated by "-", e.g. 2-5, -5, 5-
    *
    * All return a valid SQL string.
    */
   /* parseList:
    * $fieldcond = the SQL condition for the input items
    * $slist = the string containing the list of input items
    * $sep = the list separator, defaults to a single comma
    * $q1 and $q2 are the quote string to be pre/appended to the list item
    */

   function parseList($fieldcond, $slist, $sep=",", $q1="'", $q2="'") {
      $tarr = explode($sep, $slist);
      $out = $fieldcond . $q1 . $tarr[0] . $q2;
      if (count($tarr) > 1) {
         for ($i=1; $i<count($tarr); $i++) {
            if ($tarr[$i] != "") {
               $out .= " or " . $fieldcond . $q1 . $tarr[$i] . $q2;
            }
         }
      }
      return "( " . $out . " )";
   }
   /* parseArray:
    * $field = the field for the input items
    * $alist = the array containing the input items
    * $comp = the comparison to be used for the SQL string
    * $quoted = whether the items need to be quoted
    */

   function parseArray($field,$alist,$comp="=",$quoted=0) {
      if ($quoted) {
         $q1 = $q2 = "'";
         if (strtolower($comp) == "like") {
            $q1 = "'%"; $q2 = "%'";
         }
      } else {
         $q1 = $q2 = "";
      }
      $out = $field. " " . $comp . " " . $q1 . $alist[0] . $q2;
      if (count($alist) > 1) {
         for ($i=1; $i<count($alist); $i++) {
            if ($alist[$i] != "") {
               $out .= " or " . $field . " " . $comp . " " . $q1 .
                       $alist[$i] . $q2;
            }
         }
      }
      return "( " . $out . " )";
   }   

   /* parseRange:
    * $field = the field name to which the range is applied
    * $srange = the string with the range expression
    * $sep = the range expression separator, default to "-"
    * returns a string that depends on the input:
    *  INPUT       OUTPUT
    *  123         field = 123
    *  -123        field <= 123
    *  123-        field >= 123
    *  123-456     123 <= field <= 456
    */

   function parseRange($field,$srange,$sep="-",$dateitem=0) {
      $tarr = explode($sep,$srange);
         if ($dateitem) {
            $d1 = "01-Jan-";
            $d2 = "31-Dec-";
         }
         if (count($tarr) == 1) {
            if ($dateitem) {
               return "( " . $field . " >= '" . $d1 . $tarr[0] . "' and " .
                      $field." <= '".$d2.$tarr[0]."')";
            } else {
               return "( " . $field . " = " . $tarr[0] . " )";
         }
      }
      if (count($tarr) == 2) {
         if ($dateitem) {
            if ($tarr[0] == "") {
               return "( " . $field . " <= '" . $d2 . $tarr[1] . "' )";
            } elseif ($tarr[1] == "" ) {
               return "( " . $field . " >= '" . $d1.$tarr[0] . "' )";
            } else {
               return "( ".$field." >= '" . $d1 . $tarr[0] . "' and " .
                      $field." <= '" . $d2 . $tarr[1] . "' )";
            }
         } else {
            if ($tarr[0] == "") {
               return "( " . $field . " <= " . $tarr[1] . " )";
            } elseif ($tarr[1] == "" ) {
               return "( " . $field . " >= " . $tarr[0] . " )";
            } else {
               return "( " . $field . " >= " . $tarr[0] . " and " . $field .
                      " <= " . $tarr[1] . " )";
            }
         }
      } else {
         return "";
      }
   }
?>